% created by Nils Hase 2016 (nilshase@math.uni-bremen.de)

% function to plot a vector of surface flux f of dimensions 1469x1 on a map
% for the US with borders

function h = map_result(f,title_string)

if nargin == 1;
    title_string = '';
end

% Dimensions of US setup
dim_x = 94; dim_y = 31;

lon = (-145:-52) + 0.5;
lat = (25:55) + 0.5;

% Specify a colormap
[my_colormap,linecolor] = get_colors();
c_min = -0.011; c_max = 0.08;

% Load shapes for borders
load('shapes.mat')

% Plot as scaled image
my_pos = [500, 300, 600, 330];
h = figure('position',my_pos);
hold on
f_temp = zeros(dim_y,dim_x);
f_temp(land_grids) = f;
imagesc(lon,lat,f_temp);
set(gca,'YDir','normal');
for k = 1:length(US_STATE.ncst)
    plot(US_STATE.ncst{k}(:,1),US_STATE.ncst{k}(:,2),'color',linecolor,'linewidth',1);
end
for k = 1:length(COASTLINE.ncst)
    lon_points = COASTLINE.ncst{k}(:,1);
    lat_points = COASTLINE.ncst{k}(:,2);
    if sum(lon_points > lon(1)) > 0 && ...
       sum(lon_points < lon(end)) > 0 && ...
       sum(lat_points > lat(1)) > 0 && ...
       sum(lat_points < lat(end))
   
        plot(lon_points,lat_points,'color',linecolor,'linewidth',0.5);
    end
end
hold off
xlim([-133,-52])
set(gca,'xtick',[-120:20:-60])
ylim([lat(1),lat(end)])
set(gca,'ytick',[30:10:50])
colormap(my_colormap);
cb = colorbar('Ticks',[-0.02:0.01:c_max]);
pos = getpixelposition(cb);
rel_pos = pos(1:2)./my_pos(3:4);
hh = annotation('textbox',[rel_pos(1)-0.02,0.5*rel_pos(2),1-rel_pos(1),0.3*rel_pos(2)]);
set(hh,'string','$\mu \, mol \, m^{\! -2}s^{-1}$')
set(hh,'interpreter','latex')
set(hh,'fontsize',11)
set(hh,'linestyle','none')
caxis([c_min,c_max])
title(title_string)
box on
drawnow
fprintf('\n');

end
